setwd("<your directory or folder path>")
df1 <- read.csv("20191125 Example 6.1 Collinearity.csv")
#library(car) #needed to use function Anova() - not the same as anova()
# Variables
# 
# X.01
# X.02
# X.03
# X.04
# X.05
# X.06
# X.07
# X.08
# X.09
# X.10
# Response
attach(df1)
regressors <- as.matrix(cbind(const=1,X.01,X.02,X.03,X.04,X.05,X.06,X.07,X.08,X.09,X.10))
library(pls) #has function plsr
library(MASS) #has function lm.ridge
library(glmmLasso) #has function glmmLasso
model.pls <- plsr(Response ~.,data=df1,ncomp=8,method="simpls")
model.pcr <- pcr(Response ~ X.01+X.02+X.03+X.04+X.05+X.06+X.07+X.08+X.09+X.10,data=df1,ncomp=8,method="svdpc")
model.ridge <- lm.ridge(Response ~ X.01+X.02+X.03+X.04+X.05+X.06+X.07+X.08+X.09+X.10,data=df1)
model.Lasso <- glmmLasso(fix=Response~X.01+X.02+X.03+X.04+X.05+X.06+X.07+X.08+X.09+X.10,rnd=NULL,lambda=1,data=df1)
plot(model.pls,ncomp=7,main="PLS,PCR,RIDGE,LASSO: Actual vs. Predicted",xlab="Actual Response",pch=1,ylim=c(50,750))
pred.pcr <- predict(model.pcr,ncomp=7)
pred.ridge <- regressors%*%coef(model.ridge)
pred.Lasso <- predict(model.Lasso)
points(x=Response,y=pred.pcr,pch=2)
points(x=Response,y=pred.ridge,pch=3)
points(x=Response,y=pred.Lasso,pch=4)
legend(x=200,y=600,legend=c("PLS","PCR","RIDGE","LASSO"),pch=c(1,2,3,4))
